#include "Button.h"

Button::Button()
{
	state = 0;
	caption = NULL;
	nb = 0;
}

Button::~Button()
{
	free(caption);
}


void Button::setState(int s)
{
	state = s;
}

int Button::getState()
{
	return state;
}

void Button::print()
{
	printf("Etat du bouton : %d\n",state);
}

void Button::setCaption(char * c,int n)
{

	caption = (char*) realloc(caption,n*sizeof(char));
	int i;
	for(i=0;i<n;i++)
	{
		*(caption+i)=*(c+i);
	}
	nb = n;
}
int Button::getCaption(char * c)
{
	int i;
	for(i=0;i<nb;i++)
	{
		*(c+i)=*(caption+i);
	}
	return nb;
}

#define bw  9
#define bh  6

void Button::draw()
{

	if (state == 0)
	{
		glColor3ub(195,195,195);
		glBegin(GL_QUADS);
		glVertex2d(x,y);
		glVertex2d(x+bw,y);
		glVertex2d(x+bw,y+bh);
		glVertex2d(x,y+bh);
		glEnd();
		glFlush();

		glColor3ub(255,255,255);
		glBegin(GL_QUADS);
		glVertex2d(x+1,y+1);
		glVertex2d(x+bw-1,y+1);
		glVertex2d(x+bw-1,y+bh-1);
		glVertex2d(x+1,y+bh-1);
		glEnd();

		glBegin(GL_QUADS);
		glColor3ub(210,210,210);
		glVertex2d(x+2,y+2);
		glVertex2d(x+bw-2,y+2);
		glColor3ub(233,233,233);
		glVertex2d(x+bw-2,y+bh-2);
		glVertex2d(x+2,y+bh-2);
		glEnd();
	}
	else
	{
		glColor3ub(195,195,195);
		glBegin(GL_QUADS);
		glVertex2d(x,y);
		glVertex2d(x+bw,y);
		glVertex2d(x+bw,y+bh);
		glVertex2d(x,y+bh);
		glEnd();
		glFlush();

		glColor3ub(62,191,231);
		glBegin(GL_QUADS);
		glVertex2d(x+1,y+1);
		glVertex2d(x+bw-1,y+1);
		glVertex2d(x+bw-1,y+bh-1);
		glVertex2d(x+1,y+bh-1);
		glEnd();

		glBegin(GL_QUADS);
		glColor3ub(210,210,210);
		glVertex2d(x+2,y+2);
		glVertex2d(x+bw-2,y+2);
		glColor3ub(233,233,233);
		glVertex2d(x+bw-2,y+bh-2);
		glVertex2d(x+2,y+bh-2);
		glEnd();
	}

	SDL_Color color;
	SDL_Rect position;
	TTF_Font* font;
	font = TTF_OpenFont(fontpath, 8);
	color.r = 100;
	color.g = 100;
	color.b = 100;

	position.x = x+10;
	position.y = y-10;

	SDL_GL_RenderText(caption, font, color, &position);
	TTF_CloseFont(font);
}


int Button::isOver(int mousex,int mousey)
{
	if (x<=mousex && (x+bw)> mousex && y<=mousey && (y+bh)> mousey) return 1;
	else return 0;
};
