#include"Com.h"

Com::Com()
{
	connected = 0;
	uploading = 0;
}

Com::~Com()
{
	connected = 0;
	uploading = 0;
}

void Com::open(int p, int b){
  port = p;
  baudrate = b;
  if(RS232_OpenComport(p, b))
  {
    printf("Can not open com port\n");
  	connected = 0;
  } else {
  	connected = 1;
  }
  if (connected) {
  	int board = identifier_sysid_read();
  	if (board != AUTH_BOARD) {
  		printf("Board not found\n");
  		connected = 0;
  	}

  }
}

void Com::close(){
	RS232_CloseComport(port);
	connected = 0;
}

void Com::draw()
{
    SDL_Color color;
	SDL_Rect position;
	TTF_Font* font;
	font = TTF_OpenFont(fontpath, 14);

	position.x = 10;
	position.y = 740;

	if (connected){
		color.r = 0;
		color.g = 255;
		color.b = 0;
		char buffer[30];
		sprintf(buffer,"Connected to port %d", port);
		SDL_GL_RenderText(buffer, font, color, &position);
	} else {
		color.r = 0;
		color.g = 0;
		color.b = 255;
		SDL_GL_RenderText("Not Connected", font, color, &position);
	}

	position.x = 10;
	position.y = 728;

	if (uploading){
		color.r = 0;
		color.g = 0;
		color.b = 255;
		SDL_GL_RenderText("Uploading...", font, color, &position);
	}
}

void Com::write_csr(int addr, int data){
	RS232_SendByte(port, WRITE_CMD);
	RS232_SendByte(port, 1);
	RS232_SendByte(port, (addr/4 & 0xff000000) >> 24);
	RS232_SendByte(port, (addr/4 & 0x00ff0000) >> 16);
	RS232_SendByte(port, (addr/4 & 0x0000ff00) >> 8);
	RS232_SendByte(port, (addr/4 & 0x000000ff) >> 0);
	RS232_SendByte(port, data & 0xff);
}

int Com::read_csr(int addr){
	RS232_SendByte(port, READ_CMD);
	RS232_SendByte(port, 1);
	RS232_SendByte(port, (addr/4 & 0xff000000) >> 24);
	RS232_SendByte(port, (addr/4 & 0x00ff0000) >> 16);
	RS232_SendByte(port, (addr/4 & 0x0000ff00) >> 8);
	RS232_SendByte(port, (addr/4 & 0x000000ff) >> 0);
	unsigned char buffer[4];
	RS232_PollComport(port, buffer, 1);
	return (int) buffer[0];
}


/* identifier */
unsigned short int Com::identifier_sysid_read(void) {
	unsigned short int r = read_csr(0xe0001000);
	r <<= 8;
	r |= read_csr(0xe0001004);
	return r;
}

unsigned short int Com::identifier_version_read(void) {
	unsigned short int r = read_csr(0xe0001008);
	r <<= 8;
	r |= read_csr(0xe000100c);
	return r;
}

unsigned int Com::identifier_frequency_read(void) {
	unsigned int r = read_csr(0xe0001010);
	r <<= 8;
	r |= read_csr(0xe0001014);
	r <<= 8;
	r |= read_csr(0xe0001018);
	r <<= 8;
	r |= read_csr(0xe000101c);
	return r;
}

void Com::eeprom_we_write(unsigned char value) {
	write_csr(0xe0002000, value);
}

void Com::eeprom_adr_write(unsigned short int value) {
	write_csr(0xe0002004, value >> 8);
	write_csr(0xe0002008, value);
}

void Com::eeprom_dat_w_write(unsigned char value) {
	write_csr(0xe000200c, value);
}

void Com::eeprom_write_table(unsigned int base, unsigned int length, unsigned char *dat) {
	uploading = 1;
	glEnable2D();
	draw();
	glFlush();
	SDL_GL_SwapBuffers();
	unsigned int i;
	for (i=0; i<length; i++) {
		eeprom_adr_write(base+i);
		eeprom_dat_w_write(dat[base+i]);
	}
	uploading = 0;
	draw();
	glDisable2D();
	glFlush();
}