#ifndef  _COM_H
#define  _COM_H


#include "utils.h"
#include "rs232.h"

#define WRITE_CMD 0x01
#define READ_CMD  0x02
#define CLOSE_CMD 0x03

#define AUTH_BOARD 0x5041

class Com
{
	protected:
		int connected;
		int uploading;

	public:
		Com();
		~Com();
		int port;
		int baudrate;
		void open(int p, int b);
		void close();
		void draw();
		void write_csr(int addr, int data);
		int read_csr(int addr);	
		unsigned short int identifier_sysid_read(void);
		unsigned short int identifier_version_read(void);
		unsigned int identifier_frequency_read(void);
		void eeprom_we_write(unsigned char value);
		void eeprom_adr_write(unsigned short int value);
		void eeprom_dat_w_write(unsigned char value);
		void eeprom_write_table(unsigned int base, unsigned int length, unsigned char *dat);
};

#endif