#include"Eprom.h"


Eprom::Eprom()
{
}

Eprom::~Eprom()
{
}

void Eprom::lectureFichier(char * filename)
{
	FILE *fichier;
	char c;
	int i,j;
	fichier = fopen(filename,"rb+");
	i=0;
	while(!feof(fichier))
		fread(&rom[i++],1,1,fichier);

	for(i=0;i<256;i++)
	{
		tableau_avance[i] = (float)rom[AVANCE_TABLE_OFFSET+i];
		tableau_injection[i] = (float) rom[INJECTION_TABLE_OFFSET+i];
	}

	fclose(fichier);
}

void Eprom::ecritureFichier(char * filename)
{
	FILE *fichier;
	int i;
	fichier = fopen(filename,"wb+");

	for(i=0;i<256;i++)
	{
		rom[AVANCE_TABLE_OFFSET+i]    = saturate((int) tableau_avance[i]);
		rom[INJECTION_TABLE_OFFSET+i] = saturate((int) tableau_injection[i]);
	}

	for (i=0;i<32768;i++)
	{
		fprintf(fichier,"%c",rom[i]);
	}
	
	fclose(fichier);
}


void Eprom::reglageCamera(double pdistance,double ptheta,double pphi)
{
	distance = pdistance;
	theta = ptheta;
	phi = pphi;
}

float Eprom::readInjection(unsigned char rpm, unsigned char pressure)
{
	return tableau_injection[15-rpm+16*pressure];
}

float Eprom::readAvance(unsigned char rpm, unsigned char pressure)
{
	return tableau_avance[15-rpm + 16*pressure];
}

void Eprom::writeInjection(unsigned char rpm, unsigned char pressure, float value)
{
	if (value > 255.0) value = 255.0;
	if (value < 0.0) value = 0.0;
	tableau_injection[15-rpm+16*pressure] = value;
}

void Eprom::writeAvance(unsigned char rpm, unsigned char pressure, float value)
{
	if (value > 255.0) value = 255.0;
	if (value < 0.0) value = 0.0;
	tableau_avance[15-rpm + 16*pressure] = value;
}

void Eprom::multInjection(float mult)
{
	for (int j=0;j<256;j++)
	{
		float tmp = tableau_injection[j]*mult;
			tableau_injection[j] = tableau_injection[j]*mult;
	}
}

void Eprom::multAvance(float mult)
{
	for (int j=0;j<256;j++)
	{
		float tmp = tableau_avance[j]*mult;
			tableau_avance[j] = tableau_avance[j]*mult;
	}
}


void Eprom::addsubInjection(float add_sub)
{
	for (int j=0;j<256;j++)
	{
		float tmp = tableau_injection[j]+add_sub;
		tableau_injection[j] = tableau_injection[j]+add_sub;
	}
}

void Eprom::addsubAvance(float add_sub)
{
	for (int j=0;j<256;j++)
	{
		float tmp = tableau_avance[j]+add_sub;
		tableau_avance[j] = tableau_avance[j]+add_sub;
	}
}

int Eprom::saturate(int v)
{
	if (v > 255) return 255;
	else if (v < 0) return 0;
	else return v;
}

void Eprom::affichageAvance(double x,double y,double z,unsigned char rpm, unsigned char pressure)
{
int i,j,k;
	glPushMatrix();

	glTranslatef(x,y,z);
	glRotatef(theta, 0 , 0, 1);
	glRotatef(phi, 0 , 1, 0);

	for(i = 0;i<LARGEUR_TABLEAU-1 ;i++)
	{
		for(j = 0;j<LARGEUR_TABLEAU-1;j++)
		{
			unsigned char r;
			unsigned char g;
			unsigned char b;
			float h;
			float s = 1;
			float l = 0.6;
			float h_offset = 0.33;

			glBegin(GL_LINE_LOOP);
			h = k/255.0+h_offset;
			k = saturate((int) tableau_avance[i+16*(15-j)]);
			HSL2RGB(h,s,l,&r,&g,&b);
			glColor3ub(r,g,b);
			glVertex3d((LARGEUR_TABLEAU/2-i-1)*FACTEUR_DIVISION,(LARGEUR_TABLEAU/2-j-1)*FACTEUR_DIVISION, k);
			i++;
			k = saturate((int) tableau_avance[i+16*(15-j)]);
			h = k/255.0+h_offset;
			HSL2RGB(h,s,l,&r,&g,&b);
			glColor3ub(r,g,b);
			glVertex3d((LARGEUR_TABLEAU/2-i-1)*FACTEUR_DIVISION,(LARGEUR_TABLEAU/2-j-1)*FACTEUR_DIVISION, k);
			j++;
			k = saturate((int) tableau_avance[i+16*(15-j)]);
			h = k/255.0+h_offset;
			HSL2RGB(h,s,l,&r,&g,&b);
			glColor3ub(r,g,b);
			glVertex3d((LARGEUR_TABLEAU/2-i-1)*FACTEUR_DIVISION,(LARGEUR_TABLEAU/2-j-1)*FACTEUR_DIVISION, k);
			i--;
			k = saturate((int) tableau_avance[i+16*(15-j)]);
			h = k/255.0+h_offset;
			HSL2RGB(h,s,l,&r,&g,&b);
			glColor3ub(r,g,b);
			glVertex3d((LARGEUR_TABLEAU/2-i-1)*FACTEUR_DIVISION,(LARGEUR_TABLEAU/2-j-1)*FACTEUR_DIVISION, k);
			j--;
			glEnd();
		}
	}

	glColor3ub(255,255,255);
	glPointSize(3.0);
	glBegin(GL_POINTS);
	k = saturate((int) tableau_avance[15-rpm+16*pressure]);
	glVertex3d((rpm-LARGEUR_TABLEAU/2)*FACTEUR_DIVISION,(pressure-LARGEUR_TABLEAU/2)*FACTEUR_DIVISION, k);
	glEnd();

	glEnd();

	glBegin(GL_LINES);
	glVertex3d(-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d(LARGEUR_TABLEAU/2*FACTEUR_DIVISION,-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d(LARGEUR_TABLEAU/2*FACTEUR_DIVISION,-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d((LARGEUR_TABLEAU/2-0.5)*FACTEUR_DIVISION,(-LARGEUR_TABLEAU/2)*FACTEUR_DIVISION,-0.5*FACTEUR_DIVISION);
	glVertex3d(LARGEUR_TABLEAU/2*FACTEUR_DIVISION,-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d((LARGEUR_TABLEAU/2-0.5)*FACTEUR_DIVISION,-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0.5*FACTEUR_DIVISION);

	glVertex3d(-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d(-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d(-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d(-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,(LARGEUR_TABLEAU/2-0.5)*FACTEUR_DIVISION,-0.5*FACTEUR_DIVISION);
	glVertex3d(-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d(-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,(LARGEUR_TABLEAU/2-0.5)*FACTEUR_DIVISION,0.5*FACTEUR_DIVISION);
	glEnd();
	glPopMatrix();

};

void Eprom::affichageAvance2D(double x,double y,double z,unsigned char rpm,unsigned char pressure)
{
	int i,j,k;
	glEnable2D();
    SDL_Color color;
	SDL_Rect position;
	TTF_Font* font;
	font = TTF_OpenFont(fontpath, 14);

	char tmp[32];

	for(i = 0;i< LARGEUR_TABLEAU;i++)
	{
		for(j = 0;j< LARGEUR_TABLEAU;j++)
		{	

			float h;
			float s = 1;
			float l = 0.6;
			float h_offset = 0.33;

		    k = saturate((int) tableau_avance[(15-i)+16*j]);
			h = k/255.0+0.33;
			HSL2RGB(h,s,l,&color.b, &color.g, &color.r);

			if (i==rpm && j==pressure) {
					color.r = 255;
					color.g = 255;
					color.b = 255;
			}

			sprintf(tmp, "%03d", (int) tableau_avance[(15-i)+16*j]);
			position.x = 150 + i*40;
			position.y = 80 + j*40;
			SDL_GL_RenderText(tmp, font, color, &position);
		}
	}

	color.r = 255;
	color.g = 255;
	color.b = 255;
	position.x = 400;
	position.y = 50;	
	SDL_GL_RenderText("Regime -->", font, color, &position);


	color.r = 255;
	color.g = 255;
	color.b = 255;
	position.x = 50;
	position.y = 420;
	SDL_GL_RenderText("    ^   ", font, color, &position);
	position.y -=10;	
	SDL_GL_RenderText("    |   ", font, color, &position);
	position.y -=10;
	SDL_GL_RenderText("Pression", font, color, &position);


	TTF_CloseFont(font);
	glDisable2D();

};



void Eprom::affichageInjection(double x,double y,double z,unsigned char rpm,unsigned char pressure)
{
	int i,j,k;
	glPushMatrix();
	glRotatef(theta, 0 , 0, 1);
	glRotatef(phi, 0 , 1, 0);
	glTranslated(x,y,z);


	for(i = 0;i< LARGEUR_TABLEAU -1;i++)
	{
		for(j = 0;j< LARGEUR_TABLEAU -1;j++)
		{
			unsigned char r;
			unsigned char g;
			unsigned char b;
			float h;
			float s = 1;
			float l = 0.6;

			//Affichage du cadriage
			glBegin(GL_LINE_LOOP);
			k = saturate((int) tableau_injection[(15-i)+16*j]);
			h = k/255.0+0.33;
			HSL2RGB(h,s,l,&r,&g,&b);
			glColor3ub(r,g,b);
			glVertex3d((i-LARGEUR_TABLEAU/2)*FACTEUR_DIVISION,(j-LARGEUR_TABLEAU/2)*FACTEUR_DIVISION,k);
			i++;
			k = saturate((int) tableau_injection[(15-i)+16*j]);
			h = k/255.0+0.33;
			HSL2RGB(h,s,l,&r,&g,&b);
			glColor3ub(r,g,b);
			glVertex3d((i-LARGEUR_TABLEAU/2)*FACTEUR_DIVISION,(j-LARGEUR_TABLEAU/2)*FACTEUR_DIVISION,k);
			j++;
			k = saturate((int) tableau_injection[(15-i)+16*j]);
			h = k/255.0+0.33;
			HSL2RGB(h,s,l,&r,&g,&b);
			glColor3ub(r,g,b);
			glVertex3d((i-LARGEUR_TABLEAU/2)*FACTEUR_DIVISION,(j-LARGEUR_TABLEAU/2)*FACTEUR_DIVISION,k);
			i--;
			k = saturate((int) tableau_injection[(15-i)+16*j]);
			h = k/255.0+0.33;
			HSL2RGB(h,s,l,&r,&g,&b);
			glColor3ub(r,g,b);
			glVertex3d((i-LARGEUR_TABLEAU/2)*FACTEUR_DIVISION,(j-LARGEUR_TABLEAU/2)*FACTEUR_DIVISION,k);
			j--;
			glEnd();
		}
	}
	glColor3ub(255,255,255);
	glPointSize(3.0);
	glBegin(GL_POINTS);

	k = saturate((int) tableau_injection[(15-rpm)+16*pressure]);
	glVertex3d((rpm-LARGEUR_TABLEAU/2)*FACTEUR_DIVISION,(pressure-LARGEUR_TABLEAU/2)*FACTEUR_DIVISION,k);

	glEnd();

	glBegin(GL_LINES);
	glVertex3d(-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d(LARGEUR_TABLEAU/2*FACTEUR_DIVISION,-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d(LARGEUR_TABLEAU/2*FACTEUR_DIVISION,-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d((LARGEUR_TABLEAU/2-0.5)*FACTEUR_DIVISION,(-LARGEUR_TABLEAU/2)*FACTEUR_DIVISION,-0.5*FACTEUR_DIVISION);
	glVertex3d(LARGEUR_TABLEAU/2*FACTEUR_DIVISION,-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d((LARGEUR_TABLEAU/2-0.5)*FACTEUR_DIVISION,-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0.5*FACTEUR_DIVISION);

	glVertex3d(-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d(-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d(-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d(-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,(LARGEUR_TABLEAU/2-0.5)*FACTEUR_DIVISION,-0.5*FACTEUR_DIVISION);
	glVertex3d(-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,LARGEUR_TABLEAU/2*FACTEUR_DIVISION,0);
	glVertex3d(-LARGEUR_TABLEAU/2*FACTEUR_DIVISION,(LARGEUR_TABLEAU/2-0.5)*FACTEUR_DIVISION,0.5*FACTEUR_DIVISION);
	glEnd();
	glPopMatrix();

};


void Eprom::affichageInjection2D(double x,double y,double z,unsigned char rpm,unsigned char pressure)
{
	int i,j,k;
	glEnable2D();
    SDL_Color color;
	SDL_Rect position;
	TTF_Font* font;
	font = TTF_OpenFont(fontpath, 14);

	char tmp[32];

	for(i = 0;i< LARGEUR_TABLEAU;i++)
	{
		for(j = 0;j< LARGEUR_TABLEAU;j++)
		{	

			float h;
			float s = 1;
			float l = 0.6;
			float h_offset = 0.33;

		    k = saturate((int) tableau_injection[(15-i)+16*j]);
			h = k/255.0+0.33;
			HSL2RGB(h,s,l,&color.b, &color.g, &color.r);

			if (i==rpm && j==pressure) {
					color.r = 255;
					color.g = 255;
					color.b = 255;
			}

			sprintf(tmp, "%03d", (int) tableau_injection[(15-i)+16*j]);
			position.x = 150 + i*40;
			position.y = 80 + j*40;
			SDL_GL_RenderText(tmp, font, color, &position);
		}
	}
	color.r = 255;
	color.g = 255;
	color.b = 255;
	position.x = 400;
	position.y = 50;	
	SDL_GL_RenderText("Regime -->", font, color, &position);


	color.r = 255;
	color.g = 255;
	color.b = 255;
	position.x = 50;
	position.y = 420;
	SDL_GL_RenderText("    ^   ", font, color, &position);
	position.y -=10;	
	SDL_GL_RenderText("    |   ", font, color, &position);
	position.y -=10;
	SDL_GL_RenderText("Pression", font, color, &position);

	TTF_CloseFont(font);
	glDisable2D();

};


void Eprom::draw()
{
};

int Eprom::isOver(int x, int y)
{
	return 0;
}
void Eprom::print()
{

}

int Eprom::getRupteur()
{
	return 30000000/((rom[RUPTEUR_OFFSET]*256)+rom[RUPTEUR_OFFSET+1]);
}

void Eprom::setRupteur(int r)
{	
	int tmp;
	tmp = 30000000/r;
	rom[RUPTEUR_OFFSET+1] = tmp%256;
	rom[RUPTEUR_OFFSET] = tmp/256;
}


