#ifndef  _EEPROM_H
#define  _EEPROM_H


#include "utils.h"
#include "Widget.h"

#define AVANCE_TABLE_OFFSET     16388
#define INJECTION_TABLE_OFFSET  16644
#define RUPTEUR_OFFSET          23490

#define LARGEUR_TABLEAU         16
#define FACTEUR_DIVISION        8

class Eprom : public Widget
{
	public:
		Eprom();
		~Eprom();
		unsigned char rom[32768];
		float tableau_injection[256];
		float tableau_avance[256];
		double distance;
		double theta;
		double phi;
		void lectureFichier(char * filename);
		void ecritureFichier(char * filename);
		void reglageCamera(double distance,double theta,double phi);
		void printTable(double x,double y,double z, unsigned char * table, unsigned char rpm, unsigned char pressure);
		int saturate(int v);
		void affichageAvance(double x,double y,double z,unsigned char rpm,unsigned char pressure);
		void affichageAvance2D(double x,double y,double z,unsigned char rpm,unsigned char pressure);		
		void affichageInjection(double x,double y,double z,unsigned char rpm,unsigned char pressure);
		void affichageInjection2D(double x,double y,double z,unsigned char rpm,unsigned char pressure);
		float readAvance(unsigned char rpm, unsigned char pressure);
		float readInjection(unsigned char rpm, unsigned char pressure);
		void writeAvance(unsigned char rpm, unsigned char pressure, float value);
		void writeInjection(unsigned char rpm, unsigned char pressure, float value);
		void multInjection(float mult);
		void multAvance(float mult);
		void addsubInjection(float add_sub);
		void addsubAvance(float add_sub);
		void draw();
		int  isOver(int mousex,int mousey);
		void print();
		int getRupteur();
		void setRupteur(int r);
		
};

#endif