#ifndef __HW_CSR_H
#define __HW_CSR_H
#include <hw/common.h>

/* eeprom */
#define EEPROM_BASE 0xe0002000
static inline unsigned char eeprom_we_read(void) {
	return MMPTR(0xe0002000);
}
static inline void eeprom_we_write(unsigned char value) {
	MMPTR(0xe0002000) = value;
}
static inline unsigned short int eeprom_adr_read(void) {
	unsigned short int r = MMPTR(0xe0002004);
	r <<= 8;
	r |= MMPTR(0xe0002008);
	return r;
}
static inline void eeprom_adr_write(unsigned short int value) {
	MMPTR(0xe0002004) = value >> 8;
	MMPTR(0xe0002008) = value;
}
static inline unsigned char eeprom_dat_w_read(void) {
	return MMPTR(0xe000200c);
}
static inline void eeprom_dat_w_write(unsigned char value) {
	MMPTR(0xe000200c) = value;
}
static inline unsigned char eeprom_dat_r_read(void) {
	return MMPTR(0xe0002010);
}
static inline unsigned short int eeprom_tracker_base_read(void) {
	unsigned short int r = MMPTR(0xe0002014);
	r <<= 8;
	r |= MMPTR(0xe0002018);
	return r;
}
static inline void eeprom_tracker_base_write(unsigned short int value) {
	MMPTR(0xe0002014) = value >> 8;
	MMPTR(0xe0002018) = value;
}
static inline unsigned short int eeprom_tracker_end_read(void) {
	unsigned short int r = MMPTR(0xe000201c);
	r <<= 8;
	r |= MMPTR(0xe0002020);
	return r;
}
static inline void eeprom_tracker_end_write(unsigned short int value) {
	MMPTR(0xe000201c) = value >> 8;
	MMPTR(0xe0002020) = value;
}
static inline unsigned short int eeprom_tracker_adr_read(void) {
	unsigned short int r = MMPTR(0xe0002024);
	r <<= 8;
	r |= MMPTR(0xe0002028);
	return r;
}

/* identifier */
#define IDENTIFIER_BASE 0xe0001000
static inline unsigned short int identifier_sysid_read(void) {
	unsigned short int r = MMPTR(0xe0001000);
	r <<= 8;
	r |= MMPTR(0xe0001004);
	return r;
}
static inline unsigned short int identifier_version_read(void) {
	unsigned short int r = MMPTR(0xe0001008);
	r <<= 8;
	r |= MMPTR(0xe000100c);
	return r;
}
static inline unsigned int identifier_frequency_read(void) {
	unsigned int r = MMPTR(0xe0001010);
	r <<= 8;
	r |= MMPTR(0xe0001014);
	r <<= 8;
	r |= MMPTR(0xe0001018);
	r <<= 8;
	r |= MMPTR(0xe000101c);
	return r;
}

/* mila */
#define MILA_BASE 0xe0002800
static inline unsigned short int mila_trigger_port0_low_read(void) {
	unsigned short int r = MMPTR(0xe0002800);
	r <<= 8;
	r |= MMPTR(0xe0002804);
	return r;
}
static inline void mila_trigger_port0_low_write(unsigned short int value) {
	MMPTR(0xe0002800) = value >> 8;
	MMPTR(0xe0002804) = value;
}
static inline unsigned short int mila_trigger_port0_high_read(void) {
	unsigned short int r = MMPTR(0xe0002808);
	r <<= 8;
	r |= MMPTR(0xe000280c);
	return r;
}
static inline void mila_trigger_port0_high_write(unsigned short int value) {
	MMPTR(0xe0002808) = value >> 8;
	MMPTR(0xe000280c) = value;
}
static inline unsigned char mila_trigger_sum_prog_we_read(void) {
	return MMPTR(0xe0002810);
}
static inline void mila_trigger_sum_prog_we_write(unsigned char value) {
	MMPTR(0xe0002810) = value;
}
static inline unsigned char mila_trigger_sum_prog_adr_read(void) {
	return MMPTR(0xe0002814);
}
static inline void mila_trigger_sum_prog_adr_write(unsigned char value) {
	MMPTR(0xe0002814) = value;
}
static inline unsigned char mila_trigger_sum_prog_dat_read(void) {
	return MMPTR(0xe0002818);
}
static inline void mila_trigger_sum_prog_dat_write(unsigned char value) {
	MMPTR(0xe0002818) = value;
}
static inline unsigned char mila_recorder_trigger_read(void) {
	return MMPTR(0xe000281c);
}
static inline void mila_recorder_trigger_write(unsigned char value) {
	MMPTR(0xe000281c) = value;
}
static inline unsigned short int mila_recorder_length_read(void) {
	unsigned short int r = MMPTR(0xe0002820);
	r <<= 8;
	r |= MMPTR(0xe0002824);
	return r;
}
static inline void mila_recorder_length_write(unsigned short int value) {
	MMPTR(0xe0002820) = value >> 8;
	MMPTR(0xe0002824) = value;
}
static inline unsigned short int mila_recorder_offset_read(void) {
	unsigned short int r = MMPTR(0xe0002828);
	r <<= 8;
	r |= MMPTR(0xe000282c);
	return r;
}
static inline void mila_recorder_offset_write(unsigned short int value) {
	MMPTR(0xe0002828) = value >> 8;
	MMPTR(0xe000282c) = value;
}
static inline unsigned char mila_recorder_done_read(void) {
	return MMPTR(0xe0002830);
}
static inline unsigned char mila_recorder_read_en_read(void) {
	return MMPTR(0xe0002834);
}
static inline void mila_recorder_read_en_write(unsigned char value) {
	MMPTR(0xe0002834) = value;
}
static inline unsigned char mila_recorder_read_empty_read(void) {
	return MMPTR(0xe0002838);
}
static inline unsigned short int mila_recorder_read_dat_read(void) {
	unsigned short int r = MMPTR(0xe000283c);
	r <<= 8;
	r |= MMPTR(0xe0002840);
	return r;
}

/* timer0 */
#define TIMER0_BASE 0xe0001800
static inline unsigned int timer0_load_read(void) {
	unsigned int r = MMPTR(0xe0001800);
	r <<= 8;
	r |= MMPTR(0xe0001804);
	r <<= 8;
	r |= MMPTR(0xe0001808);
	r <<= 8;
	r |= MMPTR(0xe000180c);
	return r;
}
static inline void timer0_load_write(unsigned int value) {
	MMPTR(0xe0001800) = value >> 24;
	MMPTR(0xe0001804) = value >> 16;
	MMPTR(0xe0001808) = value >> 8;
	MMPTR(0xe000180c) = value;
}
static inline unsigned int timer0_reload_read(void) {
	unsigned int r = MMPTR(0xe0001810);
	r <<= 8;
	r |= MMPTR(0xe0001814);
	r <<= 8;
	r |= MMPTR(0xe0001818);
	r <<= 8;
	r |= MMPTR(0xe000181c);
	return r;
}
static inline void timer0_reload_write(unsigned int value) {
	MMPTR(0xe0001810) = value >> 24;
	MMPTR(0xe0001814) = value >> 16;
	MMPTR(0xe0001818) = value >> 8;
	MMPTR(0xe000181c) = value;
}
static inline unsigned char timer0_en_read(void) {
	return MMPTR(0xe0001820);
}
static inline void timer0_en_write(unsigned char value) {
	MMPTR(0xe0001820) = value;
}
static inline unsigned char timer0_update_value_read(void) {
	return MMPTR(0xe0001824);
}
static inline void timer0_update_value_write(unsigned char value) {
	MMPTR(0xe0001824) = value;
}
static inline unsigned int timer0_value_read(void) {
	unsigned int r = MMPTR(0xe0001828);
	r <<= 8;
	r |= MMPTR(0xe000182c);
	r <<= 8;
	r |= MMPTR(0xe0001830);
	r <<= 8;
	r |= MMPTR(0xe0001834);
	return r;
}
static inline unsigned char timer0_ev_status_read(void) {
	return MMPTR(0xe0001838);
}
static inline void timer0_ev_status_write(unsigned char value) {
	MMPTR(0xe0001838) = value;
}
static inline unsigned char timer0_ev_pending_read(void) {
	return MMPTR(0xe000183c);
}
static inline void timer0_ev_pending_write(unsigned char value) {
	MMPTR(0xe000183c) = value;
}
static inline unsigned char timer0_ev_enable_read(void) {
	return MMPTR(0xe0001840);
}
static inline void timer0_ev_enable_write(unsigned char value) {
	MMPTR(0xe0001840) = value;
}

#endif
