#include "utils.h"

int nextpoweroftwo(int x)
{
	double logbase2 = log(x) / log(2);
	return (int) round(pow(2,ceil(logbase2)));
}

void init_sdl()
{
	SDL_Init(SDL_INIT_VIDEO);
	SDL_SetVideoMode(screenwidth, screenheight, 0, SDL_OPENGL);
	SDL_WM_SetCaption(titre_fenetre, 0);
	TTF_Init();
}

void SDL_GL_RenderText(char *text,TTF_Font *font,SDL_Color color,SDL_Rect *location)
{
	SDL_Surface *initial;
	SDL_Surface *intermediary;
	SDL_Surface *temp3;
	SDL_Rect rect;
	int w,h;
	GLuint texture;

	/* Use SDL_TTF to render our text */
	initial = TTF_RenderText_Solid(font, text, color);

	/* Convert the rendered text to a known format */
	w = nextpoweroftwo(initial->w);
	h = nextpoweroftwo(initial->h);

	intermediary = SDL_CreateRGBSurface(0, w, h, 32,0x000000ff, 0x0000ff00, 0x00ff0000, 0xff000000);

	SDL_BlitSurface(initial, 0, intermediary, 0);

	SDL_SetColorKey(intermediary, SDL_SRCCOLORKEY, SDL_MapRGB(intermediary->format, 0, 0, 0));
    temp3 = SDL_DisplayFormatAlpha(intermediary);

	/* Tell GL about our new texture */
	glGenTextures(1, &texture);
	glBindTexture(GL_TEXTURE_2D, texture);


	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, w, h, 0, GL_RGBA,GL_UNSIGNED_BYTE, temp3->pixels );

	/* GL_NEAREST looks horrible, if scaled... */
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

	/* prepare to render our texture */
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, texture);
	glColor3f(1.0f, 1.0f, 1.0f);

	/* Draw a quad at location */
	glBegin(GL_QUADS);
		/* Recall that the origin is in the lower-left corner
		   That is why the TexCoords specify different corners
		   than the Vertex coors seem to. */
		glTexCoord2f(0.0f, 1.0f);
			glVertex2f(location->x    , location->y);
		glTexCoord2f(1.0f, 1.0f);
			glVertex2f(location->x + w, location->y);
		glTexCoord2f(1.0f, 0.0f);
			glVertex2f(location->x + w, location->y + h);
		glTexCoord2f(0.0f, 0.0f);
			glVertex2f(location->x    , location->y + h);
	glEnd();

	/* Bad things happen if we delete the texture before it finishes */
	glFinish();

	/* return the deltas in the unused w,h part of the rect */
	location->w = initial->w;
	location->h = initial->h;

	/* Clean up */
	SDL_FreeSurface(initial);
	SDL_FreeSurface(intermediary);
	SDL_FreeSurface(temp3);
	glDeleteTextures(1, &texture);

}

void glEnable2D()
{
	int vPort[4];

	glGetIntegerv(GL_VIEWPORT, vPort);

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();

	gluOrtho2D(0,vPort[2],0,vPort[3]);
	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();
}

void glDisable2D()
{
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
}
void init_gl()
{
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_BLEND);
	glMatrixMode( GL_PROJECTION );
	gluPerspective(50,(double)screenwidth/screenheight,0,1000);
}

float Hue_2_RGB(float v1,float v2,float vH)
{
	if (vH<0) vH += 1;
	if (vH>1) vH -= 1;
	if ((6*vH)<1) return (v1+(v2-v1)*6*vH);
	if ((2*vH)<1) return (v2);
	if ((3*vH)<2) return (v1+(v2-v1)*((2/3)-vH)*6);

	return ( v1 );
}

void HSL2RGB(float h, float s,float l,unsigned char * r,unsigned char * g,unsigned char *b)
{
	if (s==0)
	{
		*r = (unsigned char) l*255;
		*g = (unsigned char) l*255;
		*b = (unsigned char) l*255;
	}
	else
	{
		float var_1;
		float var_2;

		if (l < 0.5) var_2 = l*(1+s);
		else var_2 = (l+s)-(s*l);

		var_1 = 2*l-var_2;
	
		*r = (unsigned char) 255*Hue_2_RGB(var_1,var_2,h+ (float) 1/3);
		*g = (unsigned char) 255*Hue_2_RGB(var_1,var_2,h);
		*b = (unsigned char) 255*Hue_2_RGB(var_1,var_2,h - (float)1/3);
	}
}
